import panelNavigation from 'libraries/dom/panel_navigation.js'
import domInput        from 'libraries/dom/dom_input.js'
import storeAsInput    from 'utilities/enhancers/store_as_input.js'
import store           from 'systems/store.js'

let sections = []
let formConfig = [
  { type: 'boolean', subParent: 'control-section', params: { order: 1, storeName: 'pathFinder', path: ['activeMode'], notice: 'path finder mode toggled', text: 'Active' } }
]

function addSection (sectionConfig) {
  sections.push(sectionConfig)
}


let $menuButton
function add (_$menuButton) {
  $menuButton = _$menuButton
}


function load (onDone) {
  let childrenClasses = sections.sort((a, b) => a.order - b.order).map(({ className }) => className);

  panelNavigation.addBoundMenuPanel($menuButton, {
    id: 'path-panel',
    subDivClasses: ['control-section', ...childrenClasses]
  })

  storeAsInput.addElements('#path-panel', formConfig)

  sections.forEach(({ className, inject }) => {
    let sectionElement = document.querySelector(`#path-panel .${className}`)
    if (sectionElement) {
      inject(sectionElement)
    }
  })

  store.onNotice('pathFinder', 'path finder mode toggled', ({ activeMode }) => {
    let panel = document.getElementById('path-panel');
    let method = activeMode ? 'add' : 'remove'

    panel.classList[method]('active')
  })

  onDone()
}


export default {
  id: 'pathPanel',
  load,
  dependencies: ['path', 'toolsMenu'],
  ressources: { css: ['path_finder/ui/panel'] },
  tags: ['pathFinder', 'UI'],
  receiver: addSection,
  sendTo: {
    toolsMenu: {
      onReady: add,
      className: 'path_find',
      text: 'path',
      order: 25
    }
  }
}