import domInput     from 'libraries/dom/dom_input.js'
import store        from 'systems/store.js'
import storeAsInput from 'utilities/enhancers/store_as_input.js'

let formConfig = [
  { type: 'range', subParent: 'config-section', params: { order: 1, storeName: 'pathConfig', path: ['maxWaterHeight'],   notice: 'path config changed', text: '', min: 0,    max: 2, step: 0.01, classNames: ['water-height-range'] }},
  { type: 'range', subParent: 'config-section', params: { order: 2, storeName: 'pathConfig', path: ['minCeilingHeight'], notice: 'path config changed', text: '', min: 0.05, max: 2, step: 0.01, classNames: ['ceiling-height-range'] }}
]



function updateConfigLabels () {
  store.doWith(['pathConfig'], ({ pathConfig }) => {
    let waterLabel   = document.querySelector('#path-panel .water-height-range   span')
    let ceilingLabel = document.querySelector('#path-panel .ceiling-height-range span')

    if (waterLabel) {
      waterLabel.textContent = `Max water (${Math.round(pathConfig.maxWaterHeight * 100)}cm)`
    }

    if (ceilingLabel) {
      ceilingLabel.textContent = `Min height (${Math.round(pathConfig.minCeilingHeight * 100)}cm)`
    }
  })
}


function inject (sectionElement) {
  storeAsInput.addElements('#path-panel', formConfig)
  updateConfigLabels()
  store.onNotice('pathConfig', 'path config changed', updateConfigLabels)
}


export default {
  id: 'pathConfigUI',
  tags: ['pathFinder', 'UI'],
  dependencies: ['pathPanel'],
  sendTo: {
    pathPanel: {
      className: 'config-section',
      order: 20,
      inject
    }
  }
}