import math         from 'libraries/physics/math.js'
import store        from 'systems/store.js'
import storeAsInput from 'utilities/enhancers/store_as_input.js'

let getClosestZone
let moduleImport = { pathLib: (lib) => { getClosestZone = lib.getClosestZone }}


function mount () {
  store.mutate('pathFinder', pf => pf.clickHandlerEnabled = true)
}


let formConfig = [
  { type: 'boolean', subParent: 'click-handler', params: { order: 2, storeName: 'pathFinder', path: ['clickHandlerEnabled'], notice: 'click handler toggled', text: 'Map click' } }
]
function injectInPanel () {
  storeAsInput.addElements('#path-panel', formConfig)
}




function findNearestZone (worldX, worldY, graphData) {
  if (graphData.zones.length === 0) {
    return null
  }

  let searchPosition = { x: worldX, y: worldY }

  return getClosestZone(searchPosition)
}


function update ({ mouseWorld, pathFinder, graphData }) {
  if (pathFinder.activeMode && pathFinder.clickHandlerEnabled && mouseWorld.original.click && !mouseWorld.original.isUiAction) {
    let nearestZone = findNearestZone(mouseWorld.position.x, mouseWorld.position.y, graphData)

    if (nearestZone) {
      store.mutate('pathFinder', (pf) => pf.waypoints.push(nearestZone))
      store.notifyChange('pathFinder', 'waypoints changed')
    }
  }
}


export default {
  id: 'pathClickHandler',
  dependencies: ['path', 'pathLib'],
  tags: ['pathFinder', 'control'],
  mount,
  run: store.makeDependentTo(['mouseWorld', 'pathFinder', 'graphData'], update),
  sendTo: Object.assign(moduleImport, {
    pathPanel: {
      className: 'click-handler',
      order: 10,
      inject: injectInPanel
    }
  })
}