import cameraConverter from 'libraries/engines/camera/converter.js'
import contextDrawer   from 'libraries/engines/rendering/context_drawer.js'

import store from 'systems/store.js'




function render ({ cameraData, mapAdder }, ctx) {
  ctx.globalAlpha = mapAdder.opacity
  ctx.clearRect(0, 0, ctx.canvas.width, ctx.canvas.height)

  if (mapAdder.image) {
    drawMapImage(ctx, mapAdder, cameraData)
  }
  if (mapAdder.quarterImages) {
    drawQuartersImage(ctx, mapAdder, cameraData)
  }

  drawAnchor(ctx, mapAdder, cameraData)
}


function drawAnchor (ctx, mapAdder, cameraData) {
  if (mapAdder.anchor) {
    let circle = cameraConverter.worldToScreen(cameraData, mapAdder.anchor)

    ctx.globalAlpha = 0.7
    circle.r = 20

    contextDrawer.doCircle(ctx, circle)
    contextDrawer.fill(ctx, 'red')
    contextDrawer.stroke(ctx, 'white')
    circle.r = 1
    contextDrawer.doCircle(ctx, circle)
    contextDrawer.fill(ctx, 'white')
    ctx.globalAlpha = 1
  }
}


function drawMapImage (ctx, mapAdder, cameraData) {
  let size = {
    width:  mapAdder.image.width  * cameraData.position.z * mapAdder.z,
    height: mapAdder.image.height * cameraData.position.z * mapAdder.z
  }

  let pos = cameraConverter.worldToScreen(cameraData, mapAdder)

  ctx.drawImage(
    mapAdder.image,
    pos.x,
    pos.y,
    size.width,
    size.height
  )
}


function drawQuartersImage (ctx, mapAdder, cameraData) {
  for (let x = 0; x < 4; x++) {
    for (let y = 0; y < 4; y++) {
      drawQuarterImage(ctx, mapAdder, cameraData, x, y)
    }
  }
}



function ijToXy (i, j) {
  return {
    x: i % 2 * 2 + j % 2,
    y: Math.floor(i / 2) * 2 + Math.floor(j / 2)
  }
}


function drawQuarterImage (ctx, mapAdder, cameraData, i, j) {
  let img = mapAdder.quarterImages[i][j]
  if (!img) {
    return
  }

  let tilePos = ijToXy(i, j)

  let size = {
    width:  img.width  * cameraData.position.z * mapAdder.z,
    height: img.height * cameraData.position.z * mapAdder.z
  }

  let pos = cameraConverter.worldToScreen(cameraData, {
    x: mapAdder.x + (tilePos.x * img.width)  * mapAdder.z,
    y: mapAdder.y + (tilePos.y * img.height) * mapAdder.z
  })

  ctx.drawImage(
    img,
    pos.x,
    pos.y,
    size.width,
    size.height
  )
}





export default {
  id: 'addMapRender',
  tags: ['addMap', 'draw'],
  dependencies: ['addMapMain', 'renderers'],
  sendTo: {
    renderers: {
      zIndex: 40,
      name: 'addMap',
      run: store.makeDependentTo(['cameraData', 'mapAdder'], render)
    }
  }
}
