
import store from 'systems/store.js'




function run ({ mapAdder, mouseWorld }) {
  checkPutAnchor(mapAdder, mouseWorld)
}


function checkPutAnchor (mapAdder, mouseWorld) {
  if (mapAdder.waitSetAnchor && mouseWorld.original.click && !mouseWorld.original.isUiAction) {
    mapAdder.waitSetAnchor = false
    mapAdder.anchor = mouseWorld.position

    store.notifyChange('mapAdder', 'anchor set')
  }
}






function cameraController ({ mapAdder }, input) {
  if (mapAdder.lockCamera && (mapAdder.image || mapAdder.quarterImages)) {
    updateImageDataFromInput(input)
    return null
  } else {
    return input
  }
}


function updateImageDataFromInput (input) {
  store.doWith(['mapAdder', 'cameraData'], ({ mapAdder, cameraData }) => {
    moveFromInput(mapAdder, input)
    scaleFromInput(mapAdder, input, cameraData)

    store.update('mapAdder', mapAdder)
  })
}


function moveFromInput (mapAdder, input) {
  if (input.worldMove) {
    mapAdder.x += input.worldMove.x
    mapAdder.y += input.worldMove.y
  }
}


function getSize (mapAdder) {
  if (mapAdder.image) {
    return mapAdder.image
  }

  let first = mapAdder.quarterImages[0][0]

  return {
    width:  first.width  * 4,
    height: first.height * 4
  }
}


function scaleFromInput (mapAdder, input, cameraData) {
  let size = getSize(mapAdder)
  let frameScale = 1 + (-input.zoomForce / cameraData.position.z * mapAdder.zRatio)

  let fromPoint = mapAdder.anchor || input.focus

  let offset = {
    x: fromPoint.x - mapAdder.x,
    y: fromPoint.y - mapAdder.y
  }
  let offsetScale = {
    x: offset.x / (size.width  * mapAdder.z),
    y: offset.y / (size.height * mapAdder.z)
  }


  mapAdder.x += (size.width  * mapAdder.z) * (1 - frameScale) * offsetScale.x
  mapAdder.y += (size.height * mapAdder.z) * (1 - frameScale) * offsetScale.y
  mapAdder.z *= frameScale
}





export default {
  id: 'addMapControls',
  tags: ['addMap', 'control'],
  dependencies: ['addMapMain'],
  markAsUsed: ['isMouseOverUI'],
  sendTo: {
    camera: {
      controller: store.makeDependentTo(['mapAdder'], cameraController),
      order: 10
    }
  },
  run: store.makeDependentTo(['mapAdder', 'mouseWorld'], run)
}
