import panelNavigation from 'libraries/dom/panel_navigation.js'
import domInput        from 'libraries/dom/dom_input.js'
import storeAsInput    from 'utilities/enhancers/store_as_input.js'
import store           from 'systems/store.js'








let formConfig = [
  { type: 'image',   subParent: 'header', params: { order: 0, storeName: 'mapAdder', path: ['image'],      notice: 'image changed',      text: 'image'          } },
  { type: 'boolean', subParent: 'body',   params: { order: 1, storeName: 'mapAdder', path: ['lockCamera'], notice: 'lockCamera changed', text: 'Placement mode' } },
  { type: 'range',   subParent: 'body',   params: { order: 2, storeName: 'mapAdder', path: ['opacity'],    notice: 'opacity changed',    text: 'opacity'        } },
  { type: 'range',   subParent: 'body',   params: { order: 3, storeName: 'mapAdder', path: ['zRatio'],     notice: 'zRatio changed',     text: 'zoom sensibility', min: 0.01, max: 3, step: 0.01} }
]


function mount () {
  store.onNotice('mapAdder', ['image changed', 'quarter images initiated'], updateMapAdderData)
}


function add ($menuButton) {
panelNavigation.addBoundMenuPanel($menuButton, {
    id: 'add-map-panel',
    subDivClasses: ['header', 'body', 'button-list']
  })

  store.onNotice('mapAdder', 'image changed', activatePanelBody)
  store.onNotice('mapAdder', 'image changed', setImageNameInData)

  storeAsInput.addElements('#add-map-panel', formConfig)

  addAnchorButton()
  addHelpButton()
}


function addChild (config) {
  if (config.type === 'section') {
    addSection(config)
  } else {
    domInput.addTextButton('#add-map-panel .button-list', { text: config.text, onClick: config.onClick })
  }
}


function addSection ({ className, onCreate }) {
  let section = document.createElement('div')
  section.className = className

  let panel = document.querySelector('#add-map-panel')
  panel.appendChild(section)

  onCreate(section)
}



function addAnchorButton () {
  let anchorButton = domInput.addTextButton('#add-map-panel .button-list', {
    text: 'Add anchor',
    onClick: store.makeDependentTo(['mapAdder'], ({ mapAdder }, toggleButton) => {
      if (!mapAdder.anchor) {
        anchorButton.textContent = 'click on map'
        mapAdder.waitSetAnchor = true
      } else {
        anchorButton.textContent = 'Add anchor'
        mapAdder.waitSetAnchor = false
        mapAdder.anchor = null
      }
    })
  })

  store.onNotice('mapAdder', 'anchor set', () => {
    anchorButton.textContent = 'remove anchor'
  })
}


function addHelpButton () {
  domInput.addTextButton('#add-map-panel .button-list', {
    text: 'Help',
    onClick: () => {
      let mobileText = window.cordova
        ? `- MOBILE ONLY: Use "Quarter Load" if you have issues with large images\n`
        : ''

      alert(`
1) ADD IMAGE:
   - Click the image field at the top to upload your map image
   ${mobileText}
2) PLACEMENT MODE:
   - OFF: normal camera controls
   - ON: locks the camera and lets you move/scale the plan directly

3) ANCHOR:
   - Click "Add Anchor", then click on the map to set a reference point
   - With an anchor set (and Placement Mode enabled), the plan stays fixed while zooming

4) EXTRACT:
   - Click "Extract" once positioning is correct to generate map tiles
   - The map will appear in the maps list after refreshing

EXAMPLE WORKFLOW (don’t load the plan right away):
   - Pick a distinctive point at one end of the map
   - Set an anchor there
   - Load the plan
   - Roughly align it
   - Adjust the plan so the anchor matches the same point on the image
   - Move to the other end and scale the plan until it fits
   - Extract
    `)
    }
  })
}



function activatePanelBody () {
  document.querySelector('#add-map-panel .body').classList.add('active')
  document.querySelector('#add-map-panel .button-list').classList.add('active')
}


function setImageNameInData () {
  let removeExtension = (text) => text.split('.').slice(0, -1).join(' ')

  let mapName = removeExtension(document.querySelector('#add-map-panel .header .file-field input').files[0].name)

  store.mutate('mapAdder', (mapAdder) => mapAdder.mapName = mapName)
}




function updateMapAdderData (mapAdder) {
  store.doWith(['cameraData'], ({ cameraData }) => {
    mapAdder.x = cameraData.limit.start.x
    mapAdder.y = cameraData.limit.start.y
    mapAdder.z = 1
  })

  store.update('mapAdder', mapAdder)
}






export default {
  id: 'addMapPanel',
  tags: ['UI', 'addMap'],
  mount,
  dependencies: ['addMapMain', 'renderers', 'toolsMenu', 'camera', 'projectData', 'mouseWorld'],
  ressources: { css: ['add_map/panel'] },
  receiver: addChild,
  sendTo: {
    toolsMenu: {
      onReady: add,
      className: 'add_map',
      text: '+ Map',
      order: 20
    }
  }
}
